<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDataplex;

class GoogleCloudDataplexV1EnvironmentInfrastructureSpec extends \Google\Model
{
  /**
   * @var GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources
   */
  public $compute;
  protected $computeType = GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources::class;
  protected $computeDataType = '';
  /**
   * @var GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime
   */
  public $osImage;
  protected $osImageType = GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime::class;
  protected $osImageDataType = '';

  /**
   * @param GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources
   */
  public function setCompute(GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources $compute)
  {
    $this->compute = $compute;
  }
  /**
   * @return GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources
   */
  public function getCompute()
  {
    return $this->compute;
  }
  /**
   * @param GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime
   */
  public function setOsImage(GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime $osImage)
  {
    $this->osImage = $osImage;
  }
  /**
   * @return GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime
   */
  public function getOsImage()
  {
    return $this->osImage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDataplexV1EnvironmentInfrastructureSpec::class, 'Google_Service_CloudDataplex_GoogleCloudDataplexV1EnvironmentInfrastructureSpec');
