<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class SecurityPolicyRuleMatcher extends \Google\Model
{
  /**
   * @var SecurityPolicyRuleMatcherConfig
   */
  public $config;
  protected $configType = SecurityPolicyRuleMatcherConfig::class;
  protected $configDataType = '';
  /**
   * @var Expr
   */
  public $expr;
  protected $exprType = Expr::class;
  protected $exprDataType = '';
  /**
   * @var SecurityPolicyRuleMatcherExprOptions
   */
  public $exprOptions;
  protected $exprOptionsType = SecurityPolicyRuleMatcherExprOptions::class;
  protected $exprOptionsDataType = '';
  /**
   * @var string
   */
  public $versionedExpr;

  /**
   * @param SecurityPolicyRuleMatcherConfig
   */
  public function setConfig(SecurityPolicyRuleMatcherConfig $config)
  {
    $this->config = $config;
  }
  /**
   * @return SecurityPolicyRuleMatcherConfig
   */
  public function getConfig()
  {
    return $this->config;
  }
  /**
   * @param Expr
   */
  public function setExpr(Expr $expr)
  {
    $this->expr = $expr;
  }
  /**
   * @return Expr
   */
  public function getExpr()
  {
    return $this->expr;
  }
  /**
   * @param SecurityPolicyRuleMatcherExprOptions
   */
  public function setExprOptions(SecurityPolicyRuleMatcherExprOptions $exprOptions)
  {
    $this->exprOptions = $exprOptions;
  }
  /**
   * @return SecurityPolicyRuleMatcherExprOptions
   */
  public function getExprOptions()
  {
    return $this->exprOptions;
  }
  /**
   * @param string
   */
  public function setVersionedExpr($versionedExpr)
  {
    $this->versionedExpr = $versionedExpr;
  }
  /**
   * @return string
   */
  public function getVersionedExpr()
  {
    return $this->versionedExpr;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SecurityPolicyRuleMatcher::class, 'Google_Service_Compute_SecurityPolicyRuleMatcher');
