<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\GKEOnPrem;

class VmwareControlPlaneNodeConfig extends \Google\Model
{
  /**
   * @var VmwareAutoResizeConfig
   */
  public $autoResizeConfig;
  protected $autoResizeConfigType = VmwareAutoResizeConfig::class;
  protected $autoResizeConfigDataType = '';
  /**
   * @var string
   */
  public $cpus;
  /**
   * @var string
   */
  public $memory;
  /**
   * @var string
   */
  public $replicas;
  /**
   * @var VmwareControlPlaneVsphereConfig
   */
  public $vsphereConfig;
  protected $vsphereConfigType = VmwareControlPlaneVsphereConfig::class;
  protected $vsphereConfigDataType = '';

  /**
   * @param VmwareAutoResizeConfig
   */
  public function setAutoResizeConfig(VmwareAutoResizeConfig $autoResizeConfig)
  {
    $this->autoResizeConfig = $autoResizeConfig;
  }
  /**
   * @return VmwareAutoResizeConfig
   */
  public function getAutoResizeConfig()
  {
    return $this->autoResizeConfig;
  }
  /**
   * @param string
   */
  public function setCpus($cpus)
  {
    $this->cpus = $cpus;
  }
  /**
   * @return string
   */
  public function getCpus()
  {
    return $this->cpus;
  }
  /**
   * @param string
   */
  public function setMemory($memory)
  {
    $this->memory = $memory;
  }
  /**
   * @return string
   */
  public function getMemory()
  {
    return $this->memory;
  }
  /**
   * @param string
   */
  public function setReplicas($replicas)
  {
    $this->replicas = $replicas;
  }
  /**
   * @return string
   */
  public function getReplicas()
  {
    return $this->replicas;
  }
  /**
   * @param VmwareControlPlaneVsphereConfig
   */
  public function setVsphereConfig(VmwareControlPlaneVsphereConfig $vsphereConfig)
  {
    $this->vsphereConfig = $vsphereConfig;
  }
  /**
   * @return VmwareControlPlaneVsphereConfig
   */
  public function getVsphereConfig()
  {
    return $this->vsphereConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VmwareControlPlaneNodeConfig::class, 'Google_Service_GKEOnPrem_VmwareControlPlaneNodeConfig');
