<?php
/**
 * LiveStreamsApi
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use MuxPhp\ApiException;
use MuxPhp\Configuration;
use MuxPhp\HeaderSelector;
use MuxPhp\ObjectSerializer;

/**
 * LiveStreamsApi Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */
class LiveStreamsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex)
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createLiveStream
     *
     * Create a live stream
     *
     * @param  \MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request create_live_stream_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function createLiveStream($create_live_stream_request)
    {
        list($response) = $this->createLiveStreamWithHttpInfo($create_live_stream_request);
        return $response;
    }

    /**
     * Operation createLiveStreamWithHttpInfo
     *
     * Create a live stream
     *
     * @param  \MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamWithHttpInfo($create_live_stream_request)
    {
        $request = $this->createLiveStreamRequest($create_live_stream_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamAsync
     *
     * Create a live stream
     *
     * @param  \MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamAsync($create_live_stream_request)
    {
        return $this->createLiveStreamAsyncWithHttpInfo($create_live_stream_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamAsyncWithHttpInfo
     *
     * Create a live stream
     *
     * @param  \MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamAsyncWithHttpInfo($create_live_stream_request)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->createLiveStreamRequest($create_live_stream_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStream'
     *
     * @param  \MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLiveStreamRequest($create_live_stream_request)
    {
        // verify the required parameter 'create_live_stream_request' is set
        if ($create_live_stream_request === null || (is_array($create_live_stream_request) && count($create_live_stream_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_live_stream_request when calling createLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($create_live_stream_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($create_live_stream_request));
            } else {
                $httpBody = $create_live_stream_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLiveStreamPlaybackId
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request create_playback_id_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\CreatePlaybackIDResponse
     */
    public function createLiveStreamPlaybackId($live_stream_id, $create_playback_id_request)
    {
        list($response) = $this->createLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $create_playback_id_request);
        return $response;
    }

    /**
     * Operation createLiveStreamPlaybackIdWithHttpInfo
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\CreatePlaybackIDResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $create_playback_id_request)
    {
        $request = $this->createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MuxPhp\Models\CreatePlaybackIDResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\CreatePlaybackIDResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\CreatePlaybackIDResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\CreatePlaybackIDResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamPlaybackIdAsync
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamPlaybackIdAsync($live_stream_id, $create_playback_id_request)
    {
        return $this->createLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $create_playback_id_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamPlaybackIdAsyncWithHttpInfo
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $create_playback_id_request)
    {
        $returnType = '\MuxPhp\Models\CreatePlaybackIDResponse';
        $request = $this->createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStreamPlaybackId'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling createLiveStreamPlaybackId'
            );
        }
        // verify the required parameter 'create_playback_id_request' is set
        if ($create_playback_id_request === null || (is_array($create_playback_id_request) && count($create_playback_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_playback_id_request when calling createLiveStreamPlaybackId'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($create_playback_id_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($create_playback_id_request));
            } else {
                $httpBody = $create_playback_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLiveStreamSimulcastTarget
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request create_simulcast_target_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\SimulcastTargetResponse
     */
    public function createLiveStreamSimulcastTarget($live_stream_id, $create_simulcast_target_request)
    {
        list($response) = $this->createLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $create_simulcast_target_request);
        return $response;
    }

    /**
     * Operation createLiveStreamSimulcastTargetWithHttpInfo
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\SimulcastTargetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $create_simulcast_target_request)
    {
        $request = $this->createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MuxPhp\Models\SimulcastTargetResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\SimulcastTargetResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\SimulcastTargetResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\SimulcastTargetResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamSimulcastTargetAsync
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamSimulcastTargetAsync($live_stream_id, $create_simulcast_target_request)
    {
        return $this->createLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $create_simulcast_target_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $create_simulcast_target_request)
    {
        $returnType = '\MuxPhp\Models\SimulcastTargetResponse';
        $request = $this->createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling createLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'create_simulcast_target_request' is set
        if ($create_simulcast_target_request === null || (is_array($create_simulcast_target_request) && count($create_simulcast_target_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_simulcast_target_request when calling createLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($create_simulcast_target_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($create_simulcast_target_request));
            } else {
                $httpBody = $create_simulcast_target_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStream
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStream($live_stream_id)
    {
        $this->deleteLiveStreamWithHttpInfo($live_stream_id);
    }

    /**
     * Operation deleteLiveStreamWithHttpInfo
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->deleteLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamAsync
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamAsync($live_stream_id)
    {
        return $this->deleteLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamAsyncWithHttpInfo
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStreamPlaybackId
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStreamPlaybackId($live_stream_id, $playback_id)
    {
        $this->deleteLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id);
    }

    /**
     * Operation deleteLiveStreamPlaybackIdWithHttpInfo
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id)
    {
        $request = $this->deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamPlaybackIdAsync
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamPlaybackIdAsync($live_stream_id, $playback_id)
    {
        return $this->deleteLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamPlaybackIdAsyncWithHttpInfo
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStreamPlaybackId'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStreamPlaybackId'
            );
        }
        // verify the required parameter 'playback_id' is set
        if ($playback_id === null || (is_array($playback_id) && count($playback_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $playback_id when calling deleteLiveStreamPlaybackId'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids/{PLAYBACK_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($playback_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PLAYBACK_ID' . '}',
                ObjectSerializer::toPathValue($playback_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStreamSimulcastTarget
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStreamSimulcastTarget($live_stream_id, $simulcast_target_id)
    {
        $this->deleteLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id);
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetWithHttpInfo
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $request = $this->deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetAsync
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamSimulcastTargetAsync($live_stream_id, $simulcast_target_id)
    {
        return $this->deleteLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'simulcast_target_id' is set
        if ($simulcast_target_id === null || (is_array($simulcast_target_id) && count($simulcast_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulcast_target_id when calling deleteLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($simulcast_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SIMULCAST_TARGET_ID' . '}',
                ObjectSerializer::toPathValue($simulcast_target_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation disableLiveStream
     *
     * Disable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\DisableLiveStreamResponse
     */
    public function disableLiveStream($live_stream_id)
    {
        list($response) = $this->disableLiveStreamWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation disableLiveStreamWithHttpInfo
     *
     * Disable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\DisableLiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function disableLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->disableLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\DisableLiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\DisableLiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\DisableLiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\DisableLiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation disableLiveStreamAsync
     *
     * Disable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableLiveStreamAsync($live_stream_id)
    {
        return $this->disableLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation disableLiveStreamAsyncWithHttpInfo
     *
     * Disable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MuxPhp\Models\DisableLiveStreamResponse';
        $request = $this->disableLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'disableLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function disableLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling disableLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/disable';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation enableLiveStream
     *
     * Enable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\EnableLiveStreamResponse
     */
    public function enableLiveStream($live_stream_id)
    {
        list($response) = $this->enableLiveStreamWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation enableLiveStreamWithHttpInfo
     *
     * Enable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\EnableLiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function enableLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->enableLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\EnableLiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\EnableLiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\EnableLiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\EnableLiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation enableLiveStreamAsync
     *
     * Enable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableLiveStreamAsync($live_stream_id)
    {
        return $this->enableLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation enableLiveStreamAsyncWithHttpInfo
     *
     * Enable a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MuxPhp\Models\EnableLiveStreamResponse';
        $request = $this->enableLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'enableLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function enableLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling enableLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/enable';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLiveStream
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function getLiveStream($live_stream_id)
    {
        list($response) = $this->getLiveStreamWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation getLiveStreamWithHttpInfo
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->getLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLiveStreamAsync
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamAsync($live_stream_id)
    {
        return $this->getLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLiveStreamAsyncWithHttpInfo
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->getLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling getLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLiveStreamPlaybackId
     *
     * Retrieve a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\GetLiveStreamPlaybackIDResponse
     */
    public function getLiveStreamPlaybackId($live_stream_id, $playback_id)
    {
        list($response) = $this->getLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id);
        return $response;
    }

    /**
     * Operation getLiveStreamPlaybackIdWithHttpInfo
     *
     * Retrieve a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\GetLiveStreamPlaybackIDResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id)
    {
        $request = $this->getLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\GetLiveStreamPlaybackIDResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\GetLiveStreamPlaybackIDResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\GetLiveStreamPlaybackIDResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\GetLiveStreamPlaybackIDResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLiveStreamPlaybackIdAsync
     *
     * Retrieve a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamPlaybackIdAsync($live_stream_id, $playback_id)
    {
        return $this->getLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLiveStreamPlaybackIdAsyncWithHttpInfo
     *
     * Retrieve a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
    {
        $returnType = '\MuxPhp\Models\GetLiveStreamPlaybackIDResponse';
        $request = $this->getLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLiveStreamPlaybackId'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLiveStreamPlaybackIdRequest($live_stream_id, $playback_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling getLiveStreamPlaybackId'
            );
        }
        // verify the required parameter 'playback_id' is set
        if ($playback_id === null || (is_array($playback_id) && count($playback_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $playback_id when calling getLiveStreamPlaybackId'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids/{PLAYBACK_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($playback_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PLAYBACK_ID' . '}',
                ObjectSerializer::toPathValue($playback_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLiveStreamSimulcastTarget
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\SimulcastTargetResponse
     */
    public function getLiveStreamSimulcastTarget($live_stream_id, $simulcast_target_id)
    {
        list($response) = $this->getLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id);
        return $response;
    }

    /**
     * Operation getLiveStreamSimulcastTargetWithHttpInfo
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\SimulcastTargetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $request = $this->getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\SimulcastTargetResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\SimulcastTargetResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\SimulcastTargetResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\SimulcastTargetResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLiveStreamSimulcastTargetAsync
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamSimulcastTargetAsync($live_stream_id, $simulcast_target_id)
    {
        return $this->getLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $returnType = '\MuxPhp\Models\SimulcastTargetResponse';
        $request = $this->getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling getLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'simulcast_target_id' is set
        if ($simulcast_target_id === null || (is_array($simulcast_target_id) && count($simulcast_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulcast_target_id when calling getLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($simulcast_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SIMULCAST_TARGET_ID' . '}',
                ObjectSerializer::toPathValue($simulcast_target_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listLiveStreams
     *
     * List live streams
     *
     * @param  int $limit Number of items to include in the response (optional, default to 25)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     * @param  string $stream_key Filter response to return live stream for this stream key only (optional)
     * @param  \MuxPhp\Models\LiveStreamStatus $status Filter response to return live streams with the specified status only (optional)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\ListLiveStreamsResponse
     */
    public function listLiveStreams($limit = 25, $page = 1, $stream_key = null, $status = null)
    {
        list($response) = $this->listLiveStreamsWithHttpInfo($limit, $page, $stream_key, $status);
        return $response;
    }

    /**
     * Operation listLiveStreamsWithHttpInfo
     *
     * List live streams
     *
     * @param  int $limit Number of items to include in the response (optional, default to 25)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     * @param  string $stream_key Filter response to return live stream for this stream key only (optional)
     * @param  \MuxPhp\Models\LiveStreamStatus $status Filter response to return live streams with the specified status only (optional)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\ListLiveStreamsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listLiveStreamsWithHttpInfo($limit = 25, $page = 1, $stream_key = null, $status = null)
    {
        $request = $this->listLiveStreamsRequest($limit, $page, $stream_key, $status);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\ListLiveStreamsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\ListLiveStreamsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\ListLiveStreamsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\ListLiveStreamsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listLiveStreamsAsync
     *
     * List live streams
     *
     * @param  int $limit Number of items to include in the response (optional, default to 25)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     * @param  string $stream_key Filter response to return live stream for this stream key only (optional)
     * @param  \MuxPhp\Models\LiveStreamStatus $status Filter response to return live streams with the specified status only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listLiveStreamsAsync($limit = 25, $page = 1, $stream_key = null, $status = null)
    {
        return $this->listLiveStreamsAsyncWithHttpInfo($limit, $page, $stream_key, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listLiveStreamsAsyncWithHttpInfo
     *
     * List live streams
     *
     * @param  int $limit Number of items to include in the response (optional, default to 25)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     * @param  string $stream_key Filter response to return live stream for this stream key only (optional)
     * @param  \MuxPhp\Models\LiveStreamStatus $status Filter response to return live streams with the specified status only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listLiveStreamsAsyncWithHttpInfo($limit = 25, $page = 1, $stream_key = null, $status = null)
    {
        $returnType = '\MuxPhp\Models\ListLiveStreamsResponse';
        $request = $this->listLiveStreamsRequest($limit, $page, $stream_key, $status);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listLiveStreams'
     *
     * @param  int $limit Number of items to include in the response (optional, default to 25)
     * @param  int $page Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     * @param  string $stream_key Filter response to return live stream for this stream key only (optional)
     * @param  \MuxPhp\Models\LiveStreamStatus $status Filter response to return live streams with the specified status only (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listLiveStreamsRequest($limit = 25, $page = 1, $stream_key = null, $status = null)
    {

        $resourcePath = '/video/v1/live-streams';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            if('form' === 'form' && is_array($limit)) {
                foreach($limit as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['limit'] = $limit;
            }
        }
        // query params
        if ($page !== null) {
            if('form' === 'form' && is_array($page)) {
                foreach($page as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['page'] = $page;
            }
        }
        // query params
        if ($stream_key !== null) {
            if('form' === 'form' && is_array($stream_key)) {
                foreach($stream_key as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['stream_key'] = $stream_key;
            }
        }
        // query params
        if ($status !== null) {
            if('form' === 'form' && is_array($status)) {
                foreach($status as $key => $value) {
                    $queryParams[$key] = $value;
                }
            }
            else {
                $queryParams['status'] = $status;
            }
        }




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation resetStreamKey
     *
     * Reset a live stream's stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function resetStreamKey($live_stream_id)
    {
        list($response) = $this->resetStreamKeyWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation resetStreamKeyWithHttpInfo
     *
     * Reset a live stream's stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function resetStreamKeyWithHttpInfo($live_stream_id)
    {
        $request = $this->resetStreamKeyRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation resetStreamKeyAsync
     *
     * Reset a live stream's stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetStreamKeyAsync($live_stream_id)
    {
        return $this->resetStreamKeyAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation resetStreamKeyAsyncWithHttpInfo
     *
     * Reset a live stream's stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetStreamKeyAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->resetStreamKeyRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'resetStreamKey'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function resetStreamKeyRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling resetStreamKey'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/reset-stream-key';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation signalLiveStreamComplete
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\SignalLiveStreamCompleteResponse
     */
    public function signalLiveStreamComplete($live_stream_id)
    {
        list($response) = $this->signalLiveStreamCompleteWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation signalLiveStreamCompleteWithHttpInfo
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\SignalLiveStreamCompleteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function signalLiveStreamCompleteWithHttpInfo($live_stream_id)
    {
        $request = $this->signalLiveStreamCompleteRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\SignalLiveStreamCompleteResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\SignalLiveStreamCompleteResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\SignalLiveStreamCompleteResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\SignalLiveStreamCompleteResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation signalLiveStreamCompleteAsync
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function signalLiveStreamCompleteAsync($live_stream_id)
    {
        return $this->signalLiveStreamCompleteAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation signalLiveStreamCompleteAsyncWithHttpInfo
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function signalLiveStreamCompleteAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MuxPhp\Models\SignalLiveStreamCompleteResponse';
        $request = $this->signalLiveStreamCompleteRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'signalLiveStreamComplete'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function signalLiveStreamCompleteRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling signalLiveStreamComplete'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/complete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLiveStream
     *
     * Update a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamRequest $update_live_stream_request update_live_stream_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function updateLiveStream($live_stream_id, $update_live_stream_request)
    {
        list($response) = $this->updateLiveStreamWithHttpInfo($live_stream_id, $update_live_stream_request);
        return $response;
    }

    /**
     * Operation updateLiveStreamWithHttpInfo
     *
     * Update a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamRequest $update_live_stream_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLiveStreamWithHttpInfo($live_stream_id, $update_live_stream_request)
    {
        $request = $this->updateLiveStreamRequest($live_stream_id, $update_live_stream_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLiveStreamAsync
     *
     * Update a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamRequest $update_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamAsync($live_stream_id, $update_live_stream_request)
    {
        return $this->updateLiveStreamAsyncWithHttpInfo($live_stream_id, $update_live_stream_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLiveStreamAsyncWithHttpInfo
     *
     * Update a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamRequest $update_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamAsyncWithHttpInfo($live_stream_id, $update_live_stream_request)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->updateLiveStreamRequest($live_stream_id, $update_live_stream_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamRequest $update_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLiveStreamRequest($live_stream_id, $update_live_stream_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling updateLiveStream'
            );
        }
        // verify the required parameter 'update_live_stream_request' is set
        if ($update_live_stream_request === null || (is_array($update_live_stream_request) && count($update_live_stream_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_live_stream_request when calling updateLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_live_stream_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_live_stream_request));
            } else {
                $httpBody = $update_live_stream_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLiveStreamEmbeddedSubtitles
     *
     * Update a live stream's embedded subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamEmbeddedSubtitlesRequest $update_live_stream_embedded_subtitles_request update_live_stream_embedded_subtitles_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function updateLiveStreamEmbeddedSubtitles($live_stream_id, $update_live_stream_embedded_subtitles_request)
    {
        list($response) = $this->updateLiveStreamEmbeddedSubtitlesWithHttpInfo($live_stream_id, $update_live_stream_embedded_subtitles_request);
        return $response;
    }

    /**
     * Operation updateLiveStreamEmbeddedSubtitlesWithHttpInfo
     *
     * Update a live stream's embedded subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamEmbeddedSubtitlesRequest $update_live_stream_embedded_subtitles_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLiveStreamEmbeddedSubtitlesWithHttpInfo($live_stream_id, $update_live_stream_embedded_subtitles_request)
    {
        $request = $this->updateLiveStreamEmbeddedSubtitlesRequest($live_stream_id, $update_live_stream_embedded_subtitles_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLiveStreamEmbeddedSubtitlesAsync
     *
     * Update a live stream's embedded subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamEmbeddedSubtitlesRequest $update_live_stream_embedded_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamEmbeddedSubtitlesAsync($live_stream_id, $update_live_stream_embedded_subtitles_request)
    {
        return $this->updateLiveStreamEmbeddedSubtitlesAsyncWithHttpInfo($live_stream_id, $update_live_stream_embedded_subtitles_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLiveStreamEmbeddedSubtitlesAsyncWithHttpInfo
     *
     * Update a live stream's embedded subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamEmbeddedSubtitlesRequest $update_live_stream_embedded_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamEmbeddedSubtitlesAsyncWithHttpInfo($live_stream_id, $update_live_stream_embedded_subtitles_request)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->updateLiveStreamEmbeddedSubtitlesRequest($live_stream_id, $update_live_stream_embedded_subtitles_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLiveStreamEmbeddedSubtitles'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamEmbeddedSubtitlesRequest $update_live_stream_embedded_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLiveStreamEmbeddedSubtitlesRequest($live_stream_id, $update_live_stream_embedded_subtitles_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling updateLiveStreamEmbeddedSubtitles'
            );
        }
        // verify the required parameter 'update_live_stream_embedded_subtitles_request' is set
        if ($update_live_stream_embedded_subtitles_request === null || (is_array($update_live_stream_embedded_subtitles_request) && count($update_live_stream_embedded_subtitles_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_live_stream_embedded_subtitles_request when calling updateLiveStreamEmbeddedSubtitles'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/embedded-subtitles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_live_stream_embedded_subtitles_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_live_stream_embedded_subtitles_request));
            } else {
                $httpBody = $update_live_stream_embedded_subtitles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLiveStreamGeneratedSubtitles
     *
     * Update a live stream's generated subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamGeneratedSubtitlesRequest $update_live_stream_generated_subtitles_request update_live_stream_generated_subtitles_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MuxPhp\Models\LiveStreamResponse
     */
    public function updateLiveStreamGeneratedSubtitles($live_stream_id, $update_live_stream_generated_subtitles_request)
    {
        list($response) = $this->updateLiveStreamGeneratedSubtitlesWithHttpInfo($live_stream_id, $update_live_stream_generated_subtitles_request);
        return $response;
    }

    /**
     * Operation updateLiveStreamGeneratedSubtitlesWithHttpInfo
     *
     * Update a live stream's generated subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamGeneratedSubtitlesRequest $update_live_stream_generated_subtitles_request (required)
     *
     * @throws \MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLiveStreamGeneratedSubtitlesWithHttpInfo($live_stream_id, $update_live_stream_generated_subtitles_request)
    {
        $request = $this->updateLiveStreamGeneratedSubtitlesRequest($live_stream_id, $update_live_stream_generated_subtitles_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateLiveStreamGeneratedSubtitlesAsync
     *
     * Update a live stream's generated subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamGeneratedSubtitlesRequest $update_live_stream_generated_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamGeneratedSubtitlesAsync($live_stream_id, $update_live_stream_generated_subtitles_request)
    {
        return $this->updateLiveStreamGeneratedSubtitlesAsyncWithHttpInfo($live_stream_id, $update_live_stream_generated_subtitles_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateLiveStreamGeneratedSubtitlesAsyncWithHttpInfo
     *
     * Update a live stream's generated subtitles
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamGeneratedSubtitlesRequest $update_live_stream_generated_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLiveStreamGeneratedSubtitlesAsyncWithHttpInfo($live_stream_id, $update_live_stream_generated_subtitles_request)
    {
        $returnType = '\MuxPhp\Models\LiveStreamResponse';
        $request = $this->updateLiveStreamGeneratedSubtitlesRequest($live_stream_id, $update_live_stream_generated_subtitles_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = (string) $responseBody;
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLiveStreamGeneratedSubtitles'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  \MuxPhp\Models\UpdateLiveStreamGeneratedSubtitlesRequest $update_live_stream_generated_subtitles_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateLiveStreamGeneratedSubtitlesRequest($live_stream_id, $update_live_stream_generated_subtitles_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling updateLiveStreamGeneratedSubtitles'
            );
        }
        // verify the required parameter 'update_live_stream_generated_subtitles_request' is set
        if ($update_live_stream_generated_subtitles_request === null || (is_array($update_live_stream_generated_subtitles_request) && count($update_live_stream_generated_subtitles_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_live_stream_generated_subtitles_request when calling updateLiveStreamGeneratedSubtitles'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/generated-subtitles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($update_live_stream_generated_subtitles_request)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($update_live_stream_generated_subtitles_request));
            } else {
                $httpBody = $update_live_stream_generated_subtitles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );


        // MUX: adds support for array params.
        // TODO: future upstream?
        $query = ObjectSerializer::buildBetterQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
