<?php
/**
 * DeliveryReport
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * DeliveryReport Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class DeliveryReport implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DeliveryReport';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'live_stream_id' => 'string',
        'asset_id' => 'string',
        'passthrough' => 'string',
        'created_at' => 'string',
        'deleted_at' => 'string',
        'asset_state' => 'string',
        'asset_duration' => 'double',
        'asset_resolution_tier' => 'string',
        'delivered_seconds' => 'double',
        'delivered_seconds_by_resolution' => '\MuxPhp\Models\DeliveryReportDeliveredSecondsByResolution'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'live_stream_id' => null,
        'asset_id' => null,
        'passthrough' => null,
        'created_at' => null,
        'deleted_at' => null,
        'asset_state' => null,
        'asset_duration' => 'double',
        'asset_resolution_tier' => null,
        'delivered_seconds' => 'double',
        'delivered_seconds_by_resolution' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'live_stream_id' => false,
        'asset_id' => false,
        'passthrough' => false,
        'created_at' => false,
        'deleted_at' => false,
        'asset_state' => false,
        'asset_duration' => false,
        'asset_resolution_tier' => false,
        'delivered_seconds' => false,
        'delivered_seconds_by_resolution' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'live_stream_id' => 'live_stream_id',
        'asset_id' => 'asset_id',
        'passthrough' => 'passthrough',
        'created_at' => 'created_at',
        'deleted_at' => 'deleted_at',
        'asset_state' => 'asset_state',
        'asset_duration' => 'asset_duration',
        'asset_resolution_tier' => 'asset_resolution_tier',
        'delivered_seconds' => 'delivered_seconds',
        'delivered_seconds_by_resolution' => 'delivered_seconds_by_resolution'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'live_stream_id' => 'setLiveStreamId',
        'asset_id' => 'setAssetId',
        'passthrough' => 'setPassthrough',
        'created_at' => 'setCreatedAt',
        'deleted_at' => 'setDeletedAt',
        'asset_state' => 'setAssetState',
        'asset_duration' => 'setAssetDuration',
        'asset_resolution_tier' => 'setAssetResolutionTier',
        'delivered_seconds' => 'setDeliveredSeconds',
        'delivered_seconds_by_resolution' => 'setDeliveredSecondsByResolution'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'live_stream_id' => 'getLiveStreamId',
        'asset_id' => 'getAssetId',
        'passthrough' => 'getPassthrough',
        'created_at' => 'getCreatedAt',
        'deleted_at' => 'getDeletedAt',
        'asset_state' => 'getAssetState',
        'asset_duration' => 'getAssetDuration',
        'asset_resolution_tier' => 'getAssetResolutionTier',
        'delivered_seconds' => 'getDeliveredSeconds',
        'delivered_seconds_by_resolution' => 'getDeliveredSecondsByResolution'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ASSET_STATE_READY = 'ready';
    public const ASSET_STATE_ERRORED = 'errored';
    public const ASSET_STATE_DELETED = 'deleted';
    public const ASSET_RESOLUTION_TIER_AUDIO_ONLY = 'audio-only';
    public const ASSET_RESOLUTION_TIER__720P = '720p';
    public const ASSET_RESOLUTION_TIER__1080P = '1080p';
    public const ASSET_RESOLUTION_TIER__1440P = '1440p';
    public const ASSET_RESOLUTION_TIER__2160P = '2160p';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAssetStateAllowableValues()
    {
        return [
            self::ASSET_STATE_READY,
            self::ASSET_STATE_ERRORED,
            self::ASSET_STATE_DELETED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAssetResolutionTierAllowableValues()
    {
        return [
            self::ASSET_RESOLUTION_TIER_AUDIO_ONLY,
            self::ASSET_RESOLUTION_TIER__720P,
            self::ASSET_RESOLUTION_TIER__1080P,
            self::ASSET_RESOLUTION_TIER__1440P,
            self::ASSET_RESOLUTION_TIER__2160P,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('live_stream_id', $data ?? [], null);
        $this->setIfExists('asset_id', $data ?? [], null);
        $this->setIfExists('passthrough', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('deleted_at', $data ?? [], null);
        $this->setIfExists('asset_state', $data ?? [], null);
        $this->setIfExists('asset_duration', $data ?? [], null);
        $this->setIfExists('asset_resolution_tier', $data ?? [], null);
        $this->setIfExists('delivered_seconds', $data ?? [], null);
        $this->setIfExists('delivered_seconds_by_resolution', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAssetStateAllowableValues();
        if (!is_null($this->container['asset_state']) && !in_array($this->container['asset_state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'asset_state', must be one of '%s'",
                $this->container['asset_state'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAssetResolutionTierAllowableValues();
        if (!is_null($this->container['asset_resolution_tier']) && !in_array($this->container['asset_resolution_tier'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'asset_resolution_tier', must be one of '%s'",
                $this->container['asset_resolution_tier'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets live_stream_id
     *
     * @return string|null
     */
    public function getLiveStreamId()
    {
        return $this->container['live_stream_id'];
    }

    /**
     * Sets live_stream_id
     *
     * @param string|null $live_stream_id Unique identifier for the live stream that created the asset.
     *
     * @return self
     */
    public function setLiveStreamId($live_stream_id)
    {

        if (is_null($live_stream_id)) {
            throw new \InvalidArgumentException('non-nullable live_stream_id cannot be null');
        }

        $this->container['live_stream_id'] = $live_stream_id;

        return $this;
    }

    /**
     * Gets asset_id
     *
     * @return string|null
     */
    public function getAssetId()
    {
        return $this->container['asset_id'];
    }

    /**
     * Sets asset_id
     *
     * @param string|null $asset_id Unique identifier for the asset.
     *
     * @return self
     */
    public function setAssetId($asset_id)
    {

        if (is_null($asset_id)) {
            throw new \InvalidArgumentException('non-nullable asset_id cannot be null');
        }

        $this->container['asset_id'] = $asset_id;

        return $this;
    }

    /**
     * Gets passthrough
     *
     * @return string|null
     */
    public function getPassthrough()
    {
        return $this->container['passthrough'];
    }

    /**
     * Sets passthrough
     *
     * @param string|null $passthrough The `passthrough` value for the asset.
     *
     * @return self
     */
    public function setPassthrough($passthrough)
    {

        if (is_null($passthrough)) {
            throw new \InvalidArgumentException('non-nullable passthrough cannot be null');
        }

        $this->container['passthrough'] = $passthrough;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Time at which the asset was created. Measured in seconds since the Unix epoch.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {

        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }

        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at If exists, time at which the asset was deleted. Measured in seconds since the Unix epoch.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {

        if (is_null($deleted_at)) {
            throw new \InvalidArgumentException('non-nullable deleted_at cannot be null');
        }

        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets asset_state
     *
     * @return string|null
     */
    public function getAssetState()
    {
        return $this->container['asset_state'];
    }

    /**
     * Sets asset_state
     *
     * @param string|null $asset_state The state of the asset.
     *
     * @return self
     */
    public function setAssetState($asset_state)
    {
        $allowedValues = $this->getAssetStateAllowableValues();
        if (!is_null($asset_state) && !in_array($asset_state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'asset_state', must be one of '%s'",
                    $asset_state,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($asset_state)) {
            throw new \InvalidArgumentException('non-nullable asset_state cannot be null');
        }

        $this->container['asset_state'] = $asset_state;

        return $this;
    }

    /**
     * Gets asset_duration
     *
     * @return double|null
     */
    public function getAssetDuration()
    {
        return $this->container['asset_duration'];
    }

    /**
     * Sets asset_duration
     *
     * @param double|null $asset_duration The duration of the asset in seconds.
     *
     * @return self
     */
    public function setAssetDuration($asset_duration)
    {

        if (is_null($asset_duration)) {
            throw new \InvalidArgumentException('non-nullable asset_duration cannot be null');
        }

        $this->container['asset_duration'] = $asset_duration;

        return $this;
    }

    /**
     * Gets asset_resolution_tier
     *
     * @return string|null
     */
    public function getAssetResolutionTier()
    {
        return $this->container['asset_resolution_tier'];
    }

    /**
     * Sets asset_resolution_tier
     *
     * @param string|null $asset_resolution_tier The resolution tier that the asset was ingested at, affecting billing for ingest & storage
     *
     * @return self
     */
    public function setAssetResolutionTier($asset_resolution_tier)
    {
        $allowedValues = $this->getAssetResolutionTierAllowableValues();
        if (!is_null($asset_resolution_tier) && !in_array($asset_resolution_tier, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'asset_resolution_tier', must be one of '%s'",
                    $asset_resolution_tier,
                    implode("', '", $allowedValues)
                )
            );
        }

        if (is_null($asset_resolution_tier)) {
            throw new \InvalidArgumentException('non-nullable asset_resolution_tier cannot be null');
        }

        $this->container['asset_resolution_tier'] = $asset_resolution_tier;

        return $this;
    }

    /**
     * Gets delivered_seconds
     *
     * @return double|null
     */
    public function getDeliveredSeconds()
    {
        return $this->container['delivered_seconds'];
    }

    /**
     * Sets delivered_seconds
     *
     * @param double|null $delivered_seconds Total number of delivered seconds during this time window.
     *
     * @return self
     */
    public function setDeliveredSeconds($delivered_seconds)
    {

        if (is_null($delivered_seconds)) {
            throw new \InvalidArgumentException('non-nullable delivered_seconds cannot be null');
        }

        $this->container['delivered_seconds'] = $delivered_seconds;

        return $this;
    }

    /**
     * Gets delivered_seconds_by_resolution
     *
     * @return \MuxPhp\Models\DeliveryReportDeliveredSecondsByResolution|null
     */
    public function getDeliveredSecondsByResolution()
    {
        return $this->container['delivered_seconds_by_resolution'];
    }

    /**
     * Sets delivered_seconds_by_resolution
     *
     * @param \MuxPhp\Models\DeliveryReportDeliveredSecondsByResolution|null $delivered_seconds_by_resolution delivered_seconds_by_resolution
     *
     * @return self
     */
    public function setDeliveredSecondsByResolution($delivered_seconds_by_resolution)
    {

        if (is_null($delivered_seconds_by_resolution)) {
            throw new \InvalidArgumentException('non-nullable delivered_seconds_by_resolution cannot be null');
        }

        $this->container['delivered_seconds_by_resolution'] = $delivered_seconds_by_resolution;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


