<?php

namespace webd\language;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-12-16 at 13:38:17.
 */
class SpamSumTest extends \PHPUnit_Framework_TestCase {

    /**
     * @var SpamSum
     */
    protected $object;
    
    protected $str1 = "A string, for example the title of a spam, or the text of an email, or even the content of a webpage... Who knows? With some additional characters to make it long enough... and some more characters, I hope I will evnetually reach a sufficient lenght....\n";

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->object = new SpamSum;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * @covers webd\language\SpamSum::Hash
     * @todo   Implement testHash().
     */
    public function testHashString() {
        $this->assertEquals(
                $this->object->HashString($this->str1),
                "6:MZEYWZDrpCGgFLLELGrX+TPdLgN98M6S8HROQ9Svb:M+hpTGgiNiM58LSj");
    }

    /**
     * @covers webd\language\SpamSum::SetHashLength
     * @todo   Implement testSetHashLength().
     */
    public function testSetHashLength() {
        $s = new SpamSum;
        $s->SetHashLength(10);
        $s->HashString($this->str1);
        $this->assertEquals(
                "M0Gj58Lo",
                $s->Left());
                
    }

    /**
     * @covers webd\language\SpamSum::SetLetters
     * @todo   Implement testSetLetters().
     */
    public function testSetLetters() {
        $s = new SpamSum;
        $s->SetLetters(8);
        $s->HashString($this->str1);
        $this->assertEquals(
                "EBEAGBDDBCGAFDDEDGDHGDHFDAFFEECCEHBGAFCHD",
                $s->Left());
    }
    
    public function testSetMinBlocksize() {
        $s = new SpamSum;
        $s->SetMinBlocksize(1);
        $s->HashString($this->str1);
        $this->assertEquals(
                "4:M1yuN7qZF30RqjKgBDlWdH0eKyXCBMqGUAiDmNA1XEGAnFNuoILPaFAAhNj:MLN7qZvjKgJU0VmC7GmSFL8PaFAAhh",
                $s->__toString());
    }


    /**
     * @covers webd\language\SpamSum::__toString
     * @todo   Implement test__toString().
     */
    public function test__toString() {
        
    }

    /**
     * @covers webd\language\SpamSum::BlockSize
     * @todo   Implement testBlockSize().
     */
    public function testBlockSize() {
        
    }

    /**
     * @covers webd\language\SpamSum::Left
     * @todo   Implement testLeft().
     */
    public function testLeft() {
        
    }

    /**
     * @covers webd\language\SpamSum::Right
     * @todo   Implement testRight().
     */
    public function testRight() {
        
    }

}
